/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class UrnBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty EXPLODING = BooleanProperty.m_61465_((String)"exploding");
    public static final BooleanProperty HAS_WATER = BooleanProperty.m_61465_((String)"water");
    public static final BooleanProperty HAS_LAVA = BooleanProperty.m_61465_((String)"lava");
    public static final BooleanProperty HAS_POTION = BooleanProperty.m_61465_((String)"potion");
    public static final IntegerProperty POTION_TYPE = IntegerProperty.m_61631_((String)"type", (int)0, (int)199);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public UrnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)EXPLODING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LAVA, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_POTION, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)EXPLODING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LAVA, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)HAS_POTION, (Comparable)Boolean.valueOf(false));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState p_154235_) {
        return (Boolean)p_154235_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_154235_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{EXPLODING, HAS_WATER, HAS_LAVA, WATERLOGGED, HAS_POTION, POTION_TYPE});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (this.hasTnT(state) || this.hasLava(state) || this.hasWater(state) || this.hasPotion(state)) {
            return InteractionResult.CONSUME;
        }
        ItemStack stack = player.m_21120_(handIn);
        Item item = stack.m_41720_();
        if (item == Blocks.f_50077_.m_5456_()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)EXPLODING, (Comparable)Boolean.valueOf(true)), 0);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        if (item == Items.f_42447_) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(true)), 0);
            player.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
                ItemStack bucket = new ItemStack((ItemLike)Items.f_42446_);
                player.m_36356_(bucket);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        if (item == Items.f_42448_) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_LAVA, (Comparable)Boolean.valueOf(true)), 0);
            player.m_5496_(SoundEvents.f_11780_, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
                ItemStack bucket = new ItemStack((ItemLike)Items.f_42446_);
                player.m_36356_(bucket);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        if (item == Items.f_42589_) {
            worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)HAS_POTION, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POTION_TYPE, (Comparable)Integer.valueOf(MobEffect.m_19459_((MobEffect)((MobEffectInstance)PotionUtils.m_43547_((ItemStack)stack).get(0)).m_19544_()))), 0);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
                ItemStack bucket = new ItemStack((ItemLike)Items.f_42590_);
                player.m_36356_(bucket);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        player.m_36399_(0.005f);
        if (this.hasTnT(state)) {
            UrnBlock.explode(worldIn, pos);
        }
        if (this.hasWater(state)) {
            worldIn.m_7731_(pos, Blocks.f_49990_.m_49966_(), 0);
        }
        if (this.hasLava(state)) {
            worldIn.m_7731_(pos, Blocks.f_49991_.m_49966_(), 0);
        }
        if (this.hasPotion(state)) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            areaeffectcloudentity.m_19712_(2.5f);
            areaeffectcloudentity.m_19732_(-0.5f);
            areaeffectcloudentity.m_19740_(10);
            areaeffectcloudentity.m_19734_(areaeffectcloudentity.m_19748_() / 2);
            areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
            areaeffectcloudentity.m_19716_(new MobEffectInstance(MobEffect.m_19453_((int)this.getPotionType(state)), 300));
            player.m_7292_(new MobEffectInstance(MobEffect.m_19453_((int)this.getPotionType(state))));
            worldIn.m_7967_((Entity)areaeffectcloudentity);
        }
        UrnBlock.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockEntity)te, (Entity)player, (ItemStack)stack);
    }

    public boolean hasTnT(BlockState state) {
        return (Boolean)state.m_61143_((Property)EXPLODING);
    }

    public boolean hasWater(BlockState state) {
        return (Boolean)state.m_61143_((Property)HAS_WATER);
    }

    public boolean hasLava(BlockState state) {
        return (Boolean)state.m_61143_((Property)HAS_LAVA);
    }

    public boolean hasPotion(BlockState state) {
        return (Boolean)state.m_61143_((Property)HAS_POTION);
    }

    public int getPotionType(BlockState state) {
        return (Integer)state.m_61143_((Property)POTION_TYPE);
    }

    @Deprecated
    public static void explode(Level world, BlockPos worldIn) {
        UrnBlock.explode(world, worldIn, null);
    }

    @Deprecated
    private static void explode(Level worldIn, BlockPos pos, @Nullable LivingEntity entityIn) {
        if (!worldIn.m_5776_()) {
            PrimedTnt tntentity = new PrimedTnt(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, entityIn);
            worldIn.m_7967_((Entity)tntentity);
            worldIn.m_6263_((Player)null, (double)tntentity.m_146903_(), (double)tntentity.m_146904_(), (double)tntentity.m_146907_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

